package com.bxm.newidea.component.payment.config;

import com.alibaba.fastjson.JSONArray;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 自定义属性绑定转换器
 *
 * @author liujia
 * @date 2020/05/19 14:22
 */
@Component
@ConfigurationPropertiesBinding
public class StringToAlipayMchAccountConverter implements Converter<String, List<AlipayMchAccount>> {

    @Override
    public List<AlipayMchAccount> convert(String source) {
        if (StringUtils.isBlank(source)) {
            return Lists.newArrayList();
        }

        return JSONArray.parseArray(source, AlipayMchAccount.class);
    }
}
