package com.bxm.newidea.component.payment.config;

import lombok.Data;

import java.util.List;

/**
 * 微信支付账号配置
 *
 * @author liujia
 * @date 2020/5/31 10:09
 **/
@Data
public class WechatMchAccount {
    /**
     * 商户号别名，增加可读性
     */
    private String mchAlias;

    /**
     * 商户号描述信息
     */
    private String description;

    /**
     * 商户号ID
     */
    private String mchId;

    /**
     * 商户号密钥
     */
    private String mchKey;

    /**
     * 商户密钥文件
     */
    private String keyPath;

    /**
     * 是否使用沙箱环境
     */
    private Boolean sandbox;

    /**
     * 支付的安全域名，用于检查请求支付的地址是否合法
     */
    private List<String> securityUrls;
}
