package com.bxm.newidea.component.payment.enums;

/**
 * 支付模式枚举定义
 *
 * @author liujia
 * @date 2020/5/29 11:07
 **/
public enum PaymentModeEnum {
    /**
     * 微信的H5支付，主要用于非微信环境的H5支付，APP内嵌的webview也可使用此支付方式
     */
    WECHAT_H5,

    /**
     * 微信的JS-API支付，在微信环境的H5只能使用此方式进行支付
     */
    WECHAT_JSAPI,

    /**
     * 微信的APP支付，APP内集成SDK后可使用此支付方式
     * 因为iOS集成支付SDK的同时,必须兼容苹果支付,导致审核容易被拒绝,所以很少使用
     */
    WECHAT_APP,

    /**
     * 微信的小程序支付，类似JSAPI支付，但是不需要JSAPI的JS签名认证和安全域名
     */
    WECHAT_APPLET,

    /**
     * 支付宝的H5支付，可在APP内的webview和非支付宝环境下的H5场景使用
     */
    ALIPAY_H5,

    /**
     * 支付宝的APP支付，同微信APP支付，很少使用，原因相同
     */
    ALIPAY_APP,

    /**
     * 支付宝的小程序支付
     */
    ALIPAY_APPLET;
}
