package com.bxm.newidea.component.payment.request;

import com.bxm.newidea.component.payment.response.WechatTransfersResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liujia
 * @date 2020-07-01 13:47
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class WechatTransfersRequest extends PaymentRequest<WechatTransfersResponse> {

    /**
     * 提现订单编号
     */
    private String orderNo;

    /**
     * 提现申请的微信openId，必须是挂载在商户下的应用授权的openId
     */
    private String wechatOpenId;

    /**
     * 提现金额
     */
    private BigDecimal amount;

    /**
     * 提现备注
     */
    private String description;

    /**
     * 提现请求的来源IP
     */
    private String reqeusetIp;
}
