/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatJsapiPreOrderPaymentRequest;
import com.bxm.newidea.component.payment.response.WechatJsapiPreOrderPaymentResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.bxm.newidea.component.wechat.service.WechatMpService;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatJsapiPreOrderAction
extends BasePaymentAction
implements IPaymentAction<WechatJsapiPreOrderPaymentRequest, WechatJsapiPreOrderPaymentResponse> {
    private static final Logger log = LoggerFactory.getLogger(WechatJsapiPreOrderAction.class);
    @Autowired
    private WechatMpService wechatMpService;

    @Override
    public WechatJsapiPreOrderPaymentResponse exec(WechatJsapiPreOrderPaymentRequest request) {
        WxMpUser wxMpUser = this.wechatMpService.exchangeWxMapUser(request.getScene(), request.getWxMpAuthCode());
        if (null == wxMpUser) {
            log.error("\u8bf7\u68c0\u67e5\uff1a1.scnen\u914d\u7f6e\u7684\u5546\u6237\u53f7\u4e0e\u516c\u4f17\u53f7\u662f\u5426\u7ed1\u5b9a\uff0c2\uff1a\u6388\u6743\u7801\u662f\u5426\u6b63\u786e\uff0cscnen\u4e3a\uff1a{}\uff0c\u6388\u6743\u7801\u4e3a\uff1a{}", (Object)request.getScene(), (Object)request.getWxMpAuthCode());
            return null;
        }
        WxPayService wxPayService = this.configContext.obtainWxPayService(request.getScene());
        if (wxPayService == null) {
            return null;
        }
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType("JSAPI");
        wxPayUnifiedOrderRequest.setOpenid(wxMpUser.getOpenId());
        try {
            WxPayMpOrderResult wxPayMpOrderResult = (WxPayMpOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
            WechatJsapiPreOrderPaymentResponse response = new WechatJsapiPreOrderPaymentResponse();
            response.setAppId(wxPayMpOrderResult.getAppId());
            response.setNonceStr(wxPayMpOrderResult.getNonceStr());
            response.setPackageValue(wxPayMpOrderResult.getPackageValue());
            response.setPaySign(wxPayMpOrderResult.getPaySign());
            response.setSignType(wxPayMpOrderResult.getSignType());
            response.setTimeStamp(wxPayMpOrderResult.getTimeStamp());
            return response;
        }
        catch (WxPayException e) {
            log.error("\u521b\u5efa\u9884\u652f\u4ed8\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.JSAPI;
    }
}

