/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service;

import com.bxm.newidea.component.payment.request.PaymentRequest;
import com.bxm.newidea.component.payment.response.PaymentResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentActionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(PaymentActionDispatcher.class);
    private Map<String, IPaymentAction> actionMap = Maps.newHashMap();

    @Autowired
    public PaymentActionDispatcher(List<IPaymentAction> actionList) {
        for (IPaymentAction paymentAction : actionList) {
            String key = this.buildKey(paymentAction);
            if (this.actionMap.containsKey(key)) {
                log.error("{}\u5df2\u7ecf\u5b58\u5728,\u5b58\u5728\u91cd\u590d\u5b9a\u4e49", (Object)key);
            }
            this.actionMap.put(key, paymentAction);
        }
    }

    public <T extends PaymentResponse> T exec(PaymentRequest<T> request) {
        if (request == null || !request.verify()) {
            log.error("\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u591a\u770b\u4ee3\u7801\u6ce8\u91ca\uff01\uff01\uff01\uff01");
            return null;
        }
        String key = this.buildKey(request);
        IPaymentAction action = this.actionMap.get(key);
        if (null == action) {
            return null;
        }
        return action.exec(request);
    }

    private String buildKey(PaymentRequest request) {
        return Joiner.on((String)":").join((Object)request.getPlatform().name(), (Object)request.getMode().name(), new Object[]{request.getAction().name()});
    }

    private String buildKey(IPaymentAction paymentAction) {
        return Joiner.on((String)":").join((Object)paymentAction.matchPlatform().name(), (Object)paymentAction.matchMode().name(), new Object[]{paymentAction.matchAction().name()});
    }
}

