package com.bxm.newidea.component.payment.config;

import lombok.Data;

/**
 * 微信支付账号配置
 **/
@Data
public class WechatMchAccount {

    /**
     * 商户号描述信息
     */
    private String description;

    /**
     * 商户号ID
     */
    private String mchId;

    /**
     * 商户号密钥
     */
    private String mchKey;

    /**
     * 商户密钥文件
     */
    private String keyPath;

    /**
     * 是否使用沙箱环境
     */
    private Boolean sandbox;

    /**
     * 微信支付回调地址
     */
    private String notifyUrl;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 支付的安全域名，用于检查请求支付的地址是否合法
     */
    private String[] securityUrls;
}