/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentModeEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.WechatH5PreOrderRequest;
import com.bxm.newidea.component.payment.response.WechatH5PreOrderResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WechatH5PreOrderAction
extends BasePaymentAction
implements IPaymentAction<WechatH5PreOrderRequest, WechatH5PreOrderResponse> {
    private static final Logger log = LoggerFactory.getLogger(WechatH5PreOrderAction.class);

    @Override
    public WechatH5PreOrderResponse exec(WechatH5PreOrderRequest request) {
        WxPayService wxPayService = this.configContext.obtainWxPayService(request.getScene());
        if (wxPayService == null) {
            return null;
        }
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getOrderNum());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType("MWEB");
        try {
            WxPayMwebOrderResult result = (WxPayMwebOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
            WechatH5PreOrderResponse response = new WechatH5PreOrderResponse();
            response.setPaymentLink(result.getMwebUrl());
            return response;
        }
        catch (WxPayException e) {
            log.error("\u521b\u5efaH5\u9884\u652f\u4ed8\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.WECHAT;
    }

    @Override
    public PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }
}

