/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.bxm.newidea.component.payment.config.AlipayMchAccount;
import com.bxm.newidea.component.payment.enums.PaymentActionEnum;
import com.bxm.newidea.component.payment.enums.PaymentPlatformEnum;
import com.bxm.newidea.component.payment.request.AlipanyPaymentCallbackRequest;
import com.bxm.newidea.component.payment.response.AlipayPaymentCallbackResponse;
import com.bxm.newidea.component.payment.service.IPaymentAction;
import com.bxm.newidea.component.payment.service.impl.BasePaymentAction;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayPaymentCallbackAction
extends BasePaymentAction
implements IPaymentAction<AlipanyPaymentCallbackRequest, AlipayPaymentCallbackResponse> {
    private static final Logger log = LoggerFactory.getLogger(AlipayPaymentCallbackAction.class);

    @Override
    public AlipayPaymentCallbackResponse exec(AlipanyPaymentCallbackRequest request) {
        Map<String, String> params = this.convertMap(request.getRequest());
        try {
            HttpServletRequest httpRequest = request.getRequest();
            PrintWriter writer = request.getResponse().getWriter();
            String appId = params.get("app_id");
            AlipayMchAccount alipayMchAccount = this.configContext.obtainAlipayAccount(appId);
            boolean checkResult = AlipaySignature.rsaCheckV1(params, (String)alipayMchAccount.getPublicKey(), (String)alipayMchAccount.getCharset(), (String)alipayMchAccount.getSignType());
            if (alipayMchAccount.getEnableCheck().booleanValue() && !checkResult) {
                log.error("\u652f\u4ed8\u5b9d\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(params));
                writer.print("fail");
                return null;
            }
            AlipayPaymentCallbackResponse response = new AlipayPaymentCallbackResponse();
            response.setNotifyTime(this.getField("notify_time", httpRequest));
            response.setOutTradeNo(this.getField("out_trade_no", httpRequest));
            response.setTradeNo(this.getField("trade_no", httpRequest));
            response.setTradeStatus(this.getField("trade_status", httpRequest));
            return response;
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(params));
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getField(String fieldName, HttpServletRequest request) {
        return new String(request.getParameter(fieldName).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    private Map<String, String> convertMap(HttpServletRequest request) {
        HashMap paramMap = Maps.newHashMap();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            paramMap.put(entry.getKey(), Joiner.on((String)",").join((Object[])entry.getValue()));
        }
        return paramMap;
    }

    @Override
    public PaymentPlatformEnum matchPlatform() {
        return PaymentPlatformEnum.ALIPAY;
    }

    @Override
    public PaymentActionEnum matchAction() {
        return PaymentActionEnum.PAYMENT_CALLBACK;
    }
}

