/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.template.element;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.template.element.ImageElement;
import com.bxm.component.poster.utils.FileLoadUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularImageElement
extends ImageElement {
    private static final Logger log = LoggerFactory.getLogger(CircularImageElement.class);

    @Override
    public void render(Graphics2D posterGraphics2D, PosterContext context) throws IOException {
        String imagePath = context.getValue(this.getField());
        BufferedImage subImage = this.cutHeadImages(imagePath);
        if (null != subImage) {
            posterGraphics2D.drawImage(subImage, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
        }
    }

    private BufferedImage cutHeadImages(String imagePath) {
        BufferedImage avatarImage = null;
        try {
            InputStream inputStream = FileLoadUtil.load(imagePath, true);
            if (null == inputStream) {
                log.error("\u6e32\u67d3\u6d77\u62a5\u63d0\u4f9b\u7684\u56fe\u7247\u5730\u5740[{}]\u4e0d\u5b58\u5728", (Object)imagePath);
                return null;
            }
            avatarImage = ImageIO.read(inputStream);
            if (null == (avatarImage = this.scaleByPercentage(avatarImage, avatarImage.getWidth(), avatarImage.getWidth()))) {
                return null;
            }
            int width = avatarImage.getWidth();
            BufferedImage formatAvatarImage = new BufferedImage(width, width, 6);
            Graphics2D graphics = formatAvatarImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int border = 1;
            Ellipse2D.Double shape = new Ellipse2D.Double(border, border, width - border * 2, width - border * 2);
            graphics.setClip(shape);
            graphics.drawImage(avatarImage, border, border, width - border * 2, width - border * 2, null);
            graphics.dispose();
            graphics = formatAvatarImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int border1 = 3;
            BasicStroke s = new BasicStroke(5.0f, 1, 1);
            graphics.setStroke(s);
            graphics.setColor(Color.WHITE);
            graphics.drawOval(border1, border1, width - border1 * 2, width - border1 * 2);
            graphics.dispose();
            return formatAvatarImage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private BufferedImage scaleByPercentage(BufferedImage inputImage, int newWidth, int newHeight) {
        try {
            int type = inputImage.getColorModel().getTransparency();
            int width = inputImage.getWidth();
            int height = inputImage.getHeight();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            BufferedImage img = new BufferedImage(newWidth, newHeight, type);
            Graphics2D graphics2d = img.createGraphics();
            graphics2d.setRenderingHints(renderingHints);
            graphics2d.drawImage(inputImage, 0, 0, newWidth, newHeight, 0, 0, width, height, null);
            graphics2d.dispose();
            return img;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CircularImageElement)) {
            return false;
        }
        CircularImageElement other = (CircularImageElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CircularImageElement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CircularImageElement()";
    }
}

