/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.engine;

import com.bxm.component.poster.config.PosterConfiguration;
import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.output.IPosterOutput;
import com.bxm.component.poster.output.impl.LocalPosterOutput;
import com.bxm.component.poster.template.PosterTemplate;
import com.bxm.component.poster.utils.FontManage;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PosterEngine {
    private static final Logger log = LoggerFactory.getLogger(PosterEngine.class);
    private IPosterOutput defaultPosterOutput = new LocalPosterOutput();
    private final PosterConfiguration posterConfiguration;
    private AtomicBoolean initFlag = new AtomicBoolean(false);

    @Autowired
    public PosterEngine(PosterConfiguration posterConfiguration) {
        this.posterConfiguration = posterConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generate(PosterContext context) {
        String posterPath;
        IPosterOutput posterOutput;
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u521b\u5efa\u6d77\u62a5\uff0c\u521b\u5efa\u53c2\u6570\uff1a{}", (Object)context);
        }
        if ((posterOutput = context.getPosterOutput()) == null) {
            posterOutput = this.defaultPosterOutput;
        }
        if (!context.isOverwrite() && StringUtils.isNotBlank((CharSequence)(posterPath = posterOutput.exists(context)))) {
            log.debug("\u547d\u4e2d\u7f13\u5b58\uff0c\u76f4\u63a5\u8fd4\u56de\u6d77\u62a5\u5730\u5740\uff1a{}\uff0c\u603b\u8017\u65f6\uff1a{}", (Object)posterPath, (Object)(System.currentTimeMillis() - start));
            return posterPath;
        }
        PosterTemplate template = this.loadTemplate(context);
        if (template == null) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (Object)context.getTemplate());
            return "";
        }
        File tempPosterFile = null;
        try {
            tempPosterFile = template.render(context);
            String output = posterOutput.output(context, tempPosterFile);
            if (log.isDebugEnabled()) {
                log.debug("\u6d77\u62a5\u5408\u6210\u7ed3\u675f\uff0c\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            }
            String string = output;
            return string;
        }
        finally {
            if (null != tempPosterFile && tempPosterFile.exists() && !tempPosterFile.delete()) {
                log.warn("\u6587\u4ef6\u672a\u6b63\u5e38\u79fb\u9664\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)tempPosterFile.getAbsolutePath());
            }
        }
    }

    private void init() {
        if (this.initFlag.compareAndSet(false, true)) {
            FontManage.init();
        }
    }

    private PosterTemplate loadTemplate(PosterContext context) {
        for (Map.Entry<String, PosterTemplate> entry : this.posterConfiguration.getTemplateMap().entrySet()) {
            if (!StringUtils.equals((CharSequence)context.getTemplate(), (CharSequence)entry.getValue().getName())) continue;
            return entry.getValue();
        }
        return null;
    }
}

