/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.poster.utils;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileLoadUtil.class);

    public static InputStream load(String filePath, boolean cache) {
        File loadFile = FileLoadUtil.loadFile(filePath, cache);
        if (null != loadFile) {
            return new FileInputStream(loadFile);
        }
        return null;
    }

    private static String buildLocalPath(String remotePath) {
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        String targetDirectory = null;
        try {
            targetDirectory = sysTempDir.getCanonicalPath();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u4e34\u65f6\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        long hashCode = remotePath.hashCode();
        String fileExtension = com.bxm.newidea.component.tools.FileUtils.getFilextension((String)remotePath);
        return targetDirectory + hashCode % 100L + File.separator + hashCode + "." + fileExtension;
    }

    private static boolean isRemote(String filePath) {
        return StringUtils.startsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{"http:", "https:"});
    }

    public static File loadFile(String filePath, boolean cache) {
        File localFile;
        if (FileLoadUtil.isRemote(filePath)) {
            String localPath = FileLoadUtil.buildLocalPath(filePath);
            localFile = new File(localPath);
            if (cache && localFile.exists()) {
                return localFile;
            }
            OkHttpUtils.download((String)filePath, response -> {
                if (response.body() != null) {
                    try {
                        com.bxm.newidea.component.tools.FileUtils.checkAndCreateFile((File)localFile);
                        FileUtils.writeByteArrayToFile((File)localFile, (byte[])response.body().bytes());
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        } else {
            localFile = new File(filePath);
            if (!localFile.exists()) {
                return null;
            }
        }
        return localFile;
    }
}

