/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.cloud.config;

import com.bxm.newidea.cloud.ribbon.EnvDiscoveryEnabledRule;
import com.bxm.newidea.cloud.web.HttpHeaderHandlerInterceptorAdapter;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnClass(value={DiscoveryEnabledNIWSServerList.class})
@AutoConfigureAfter(value={RibbonClientConfiguration.class})
public class PreWebConfiguration
implements WebMvcConfigurer {
    private String name = "client";

    @Bean
    public HttpHeaderHandlerInterceptorAdapter interceptorAdapter() {
        return new HttpHeaderHandlerInterceptorAdapter();
    }

    @Bean
    public IClientConfig ribbonClientConfig() {
        DefaultClientConfigImpl config = new DefaultClientConfigImpl();
        config.loadProperties(this.name);
        config.set(CommonClientConfigKey.ConnectTimeout, (Object)1000);
        config.set(CommonClientConfigKey.ReadTimeout, (Object)1000);
        return config;
    }

    @Bean
    public EnvDiscoveryEnabledRule envDiscoveryEnabledRule() {
        EnvDiscoveryEnabledRule rule = new EnvDiscoveryEnabledRule();
        rule.initWithNiwsConfig(this.ribbonClientConfig());
        return rule;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptorAdapter());
    }
}

