/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.cloud.ribbon;

import com.bxm.newidea.cloud.ribbon.RibbonFilterContext;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import com.google.common.base.Optional;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvDiscoveryEnabledRule
extends ZoneAvoidanceRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvDiscoveryEnabledRule.class);

    public Server choose(Object key) {
        Optional server;
        RibbonFilterContext context = RibbonFilterContextHolder.getCurrentContext();
        ILoadBalancer lb = this.getLoadBalancer();
        List allServers = lb.getAllServers();
        ArrayList<Server> matchedMetaServers = new ArrayList<Server>();
        Map<String, String> attributes = context.getAttributes();
        String ribbonVal = attributes.get("env");
        LOGGER.debug("request server:" + key + ",ribbonVal:" + ribbonVal);
        if (StringUtils.isNotBlank((String)ribbonVal)) {
            for (Server server2 : allServers) {
                DiscoveryEnabledServer discoveryEnabledServer;
                Map metadata;
                String env;
                if (!(server2 instanceof DiscoveryEnabledServer) || !StringUtils.isNotBlank((String)(env = (String)(metadata = (discoveryEnabledServer = (DiscoveryEnabledServer)server2).getInstanceInfo().getMetadata()).get("env"))) || !"pre".equals(env)) continue;
                matchedMetaServers.add(server2);
            }
            if (!matchedMetaServers.isEmpty()) {
                server = this.getPredicate().chooseRoundRobinAfterFiltering(matchedMetaServers, key);
                if (server.isPresent()) {
                    LOGGER.debug("choose server: " + ((Server)server.get()).getId() + ",env:" + ribbonVal + ",key:" + key);
                    return (Server)server.get();
                }
                LOGGER.error("\u8bf7\u6c42\u5934\u4fe1\u606f\u4e2d\u5305\u542b\u9884\u53d1\u952e\u503c\uff0c\u4f46\u662f\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u670d\u52a1\uff0c\u8bf7\u6c42key\uff1a" + key);
                return null;
            }
            LOGGER.error("\u8bf7\u6c42\u5934\u4fe1\u606f\u4e2d\u5305\u542b\u9884\u53d1\u952e\u503c\uff0c\u4f46\u662f\u672a\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u7684\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u90e8\u7f72\u7684eureka metadata\uff0c\u8bf7\u6c42key\uff1a{},ribbonVal:{}", key, (Object)ribbonVal);
        }
        if ((server = this.getPredicate().chooseRoundRobinAfterFiltering(allServers, key)).isPresent()) {
            LOGGER.debug("choose server: " + ((Server)server.get()).getId() + ",key:" + key + ",ribbonVal:" + ribbonVal);
            return (Server)server.get();
        }
        return null;
    }
}

