/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.cloud.config;

import com.bxm.newidea.cloud.ribbon.EnvDiscoveryEnabledRule;
import com.bxm.newidea.cloud.web.HttpHeaderHandlerInterceptorAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@RibbonClients(defaultConfiguration={PreWebConfiguration.class})
public class PreWebConfiguration
implements WebMvcConfigurer {
    @Value(value="${ribbon.client.name:#{null}}")
    private String name;
    @Autowired(required=false)
    private IClientConfig config;
    @Autowired
    private PropertiesFactory propertiesFactory;

    @Bean
    @Lazy
    public IRule ribbonRule() {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return null;
        }
        if (this.propertiesFactory.isSet(IRule.class, this.name)) {
            return (IRule)this.propertiesFactory.get(IRule.class, this.config, this.name);
        }
        EnvDiscoveryEnabledRule rule = new EnvDiscoveryEnabledRule();
        rule.initWithNiwsConfig(this.config);
        return rule;
    }

    @Bean
    public HttpHeaderHandlerInterceptorAdapter interceptorAdapter() {
        return new HttpHeaderHandlerInterceptorAdapter();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptorAdapter());
    }
}

