package com.bxm.component.preheat.config;

import com.bxm.component.preheat.constant.PreheatConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.bxm.component.preheat.constant.PreheatConstant.PREHEAT_ENABLED;

/**
 * 前置执行环境变量的强制替换，使得模块生效
 *
 * @author liujia
 * @date 2022/07/26 15:50:16
 * @since 2.2.1
 */
@Slf4j
public class PreheatEnvironmentPostProcessor implements EnvironmentPostProcessor, Ordered {

    private final AtomicBoolean INIT_FLAG = new AtomicBoolean(false);

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (INIT_FLAG.compareAndSet(false, true)) {
            String preheatEnabled = environment.getProperty(PREHEAT_ENABLED, "true");

            if (Boolean.parseBoolean(preheatEnabled)) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<>();
                map.put(PreheatConstant.SERVICE_AUTO_REGISTRATION_ENABLED, false);
                map.put(PreheatConstant.ENABLE_HEALTH_READINESSSTATE, true);
                
                MapPropertySource propertySource = new MapPropertySource("preheatFocusEnableEndPoint", map);
                environment.getPropertySources().addLast(propertySource);
            } else {
                log.info("[c-preheat] 设置了{}为false，不进行预热处理", PREHEAT_ENABLED);
            }
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
