package com.bxm.component.preheat.phaser.aliyunoss;

import com.bxm.component.preheat.config.PreheatAutoConfiguration;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 阿里云oss客户端链接预热
 *
 * @author liujia
 * @date 2022/07/27 16:32:25
 * @since 2.2.1
 */
@Configuration
@ConditionalOnClass(AliyunOSSService.class)
@AutoConfigureAfter(PreheatAutoConfiguration.class)
public class AliyunOssPreheatAutoConfiguration {

    @Bean
    @ConditionalOnBean(AliyunOSSService.class)
    public AliyunClientPreheatPhaser aliyunClientPreheatPhaser(AliyunOSSService aliyunOSSService) {
        return new AliyunClientPreheatPhaser(aliyunOSSService);
    }
}
