package com.bxm.component.preheat.phaser.database;

import com.bxm.component.preheat.config.PreheatAutoConfiguration;
import com.bxm.component.preheat.properties.PreheatConfigurationProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.util.List;

/**
 * 数据库连接池预热自动装配
 *
 * @author liujia
 * @date 2022/07/27 16:32:57
 * @since 2.2.1
 */
@Configuration
@ConditionalOnClass(DataSource.class)
@AutoConfigureAfter(PreheatAutoConfiguration.class)
public class DatabasePreheatAutoConfiguration {

    @Bean
    @ConditionalOnBean(DataSource.class)
    public DatabasePreheatPhaser databasePreheatPhaser(List<DataSource> dataSourceList,
                                                       PreheatConfigurationProperties properties) {
        return new DatabasePreheatPhaser(dataSourceList, properties);
    }
}
