package com.bxm.component.preheat.phaser.database;

import com.bxm.component.preheat.properties.PreheatConfigurationProperties;
import com.bxm.newidea.component.core.PreheatPhaser;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 * 数据库连接池预热
 *
 * @author liujia
 * @date 2022/07/27 14:58:29
 * @since 2.2.1
 */
@Slf4j
@AllArgsConstructor
public class DatabasePreheatPhaser implements PreheatPhaser {

    private List<DataSource> dataSourceList;

    private PreheatConfigurationProperties properties;

    @Override
    public void handle() {
        try {
            for (DataSource dataSource : dataSourceList) {
                Connection connection = dataSource.getConnection();
                Statement statement = connection.createStatement();
                statement.execute(properties.getDetectSql());
                statement.close();
                connection.close();
            }
        } catch (SQLException e) {
            log.error(e.getMessage(), e);
        }
    }
}
