package com.bxm.component.preheat.phaser.mvc;

import com.bxm.component.preheat.config.PreheatAutoConfiguration;
import com.bxm.component.preheat.phaser.mvc.internal.DetectValidParam;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.annotations.ApiVersion;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * spring mvc请求预热
 *
 * @author liujia
 * @date 2022/07/27 16:33:17
 * @since 2.2.1
 */
@Configuration
@ConditionalOnWebApplication
@Slf4j
@AutoConfigureAfter(PreheatAutoConfiguration.class)
public class WebMvcPreheatAutoConfiguration {

    @Bean
    public WebMvcPreheatPhaser webMvcPreheatPhaser() {
        return new WebMvcPreheatPhaser();
    }

    @RestController
    @RequestMapping("{version}/expose/detect")
    public class InnerDetectController {

        @PostMapping("valid")
        @ApiVersion(1)
        public boolean request(@RequestBody DetectValidParam param) {
            log.debug("[c-preheat] 探测参数:{}", JSON.toJSONString(param));
            return true;
        }
    }
}
