package com.bxm.component.preheat.phaser.mvc.internal;

import lombok.Data;

import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 探测请求参数，用于激活校验框架
 *
 * @author liujia
 * @date 2022/07/27 15:37:29
 * @since 2.2.1
 */
@Data
public class DetectValidParam {

    @NotNull
    @Size(min = 3, max = 20)
    private String str;

    @Min(value = 10)
    private Integer num;

    @Max(999)
    private BigDecimal decimal;

    @Future
    private Date date;
}
