package com.bxm.component.preheat.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 预热相关配置
 *
 * @author liujia
 * @date 2022/07/26 16:39:42
 * @since 2.2.1
 */
@ConfigurationProperties(prefix = "component.preheat")
@Data
public class PreheatConfigurationProperties {

    /**
     * 执行预热的超时时间（毫秒）
     */
    private Long executeTimeoutMills = 15 * 1000L;

    /**
     * 数据库查询探测sql
     */
    private String detectSql = "select 1 from dual";
}
