package com.bxm.component.preheat.registration.nacos;

import com.alibaba.cloud.nacos.registry.NacosAutoServiceRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistryAutoConfiguration;
import com.bxm.component.preheat.registration.RegistrationNotify;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 实现手动的nacos服务注册，替换默认的注册服务
 * 参见：
 * {@link NacosServiceRegistryAutoConfiguration}
 *
 * @author liujia
 * @date 2022/07/27 13:49:05
 * @since 2.2.1
 */
@Slf4j
public class ManualNacosServiceRegistration extends NacosAutoServiceRegistration implements RegistrationNotify {

    private final AtomicBoolean startFlag = new AtomicBoolean(false);

    public ManualNacosServiceRegistration(ServiceRegistry<Registration> serviceRegistry,
                                          AutoServiceRegistrationProperties autoServiceRegistrationProperties,
                                          NacosRegistration registration) {
        super(serviceRegistry, autoServiceRegistrationProperties, registration);
    }

    @Override
    public void readinessNotify() {
        log.info("[c-preheat] 执行nacos服务注册");
        startFlag.set(true);
        start();
        log.info("[c-preheat] nacos服务注册完成");
    }

    @Override
    public void start() {
        if (startFlag.get()) {
            super.start();
        } else {
            log.debug("[c-preheat] 预热未结束，不启动nacos注册");
        }
    }
}
