package com.bxm.component.preheat.registration.nacos;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 替换nacos本身的自动装配（居然不支持另外设置类来单独替换，简直了）
 * 参见：
 * {@link NacosServiceRegistryAutoConfiguration}
 *
 * @author liujia
 * @date 2022/07/27 14:10:18
 * @since 2.2.1
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnNacosDiscoveryEnabled
@ConditionalOnClass({
    NacosServiceRegistry.class,
    NacosRegistration.class
})
@AutoConfigureAfter({
    NacosDiscoveryAutoConfiguration.class
})
@EnableConfigurationProperties(AutoServiceRegistrationProperties.class)
public class PreheatNacosServiceRegistryAutoConfiguration {

    private AutoServiceRegistrationProperties properties;

    @Bean
    @ConditionalOnBean(NacosDiscoveryProperties.class)
    public NacosServiceRegistry nacosServiceRegistry(NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServiceRegistry(nacosDiscoveryProperties);
    }

    @Bean
    @ConditionalOnBean(NacosDiscoveryProperties.class)
    public NacosRegistration nacosRegistration(
        ObjectProvider<List<NacosRegistrationCustomizer>> registrationCustomizers,
        NacosDiscoveryProperties nacosDiscoveryProperties,
        ApplicationContext context) {
        return new NacosRegistration(
            registrationCustomizers.getIfAvailable(),
            nacosDiscoveryProperties,
            context
        );
    }

    @Bean
    public ManualNacosServiceRegistration nacosAutoServiceRegistration(NacosServiceRegistry registry,
                                                                       NacosRegistration registration) {
        return new ManualNacosServiceRegistration(registry, properties, registration
        );
    }

}