/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.preheat.config;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class PreheatEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(PreheatEnvironmentPostProcessor.class);
    private final AtomicBoolean INIT_FLAG = new AtomicBoolean(false);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.INIT_FLAG.compareAndSet(false, true)) {
            String preheatEnabled = environment.getProperty("component.preheat.enabled", "true");
            if (Boolean.parseBoolean(preheatEnabled)) {
                LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
                map.put("spring.cloud.service-registry.auto-registration.enabled", false);
                map.put("management.health.readinessstate.enabled", true);
                MapPropertySource propertySource = new MapPropertySource("preheatFocusEnableEndPoint", map);
                environment.getPropertySources().addLast((PropertySource)propertySource);
            } else {
                log.info("[c-preheat] \u8bbe\u7f6e\u4e86{}\u4e3afalse\uff0c\u4e0d\u8fdb\u884c\u9884\u70ed\u5904\u7406", (Object)"component.preheat.enabled");
            }
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

