/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.preheat.phaser.database;

import com.bxm.component.preheat.properties.PreheatConfigurationProperties;
import com.bxm.newidea.component.core.PreheatPhaser;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePreheatPhaser
implements PreheatPhaser {
    private static final Logger log = LoggerFactory.getLogger(DatabasePreheatPhaser.class);
    private List<DataSource> dataSourceList;
    private PreheatConfigurationProperties properties;

    public void handle() {
        try {
            for (DataSource dataSource : this.dataSourceList) {
                Connection connection = dataSource.getConnection();
                Statement statement = connection.createStatement();
                statement.execute(this.properties.getDetectSql());
                statement.close();
                connection.close();
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public DatabasePreheatPhaser(List<DataSource> dataSourceList, PreheatConfigurationProperties properties) {
        this.dataSourceList = dataSourceList;
        this.properties = properties;
    }
}

