/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.preheat.registration.nacos;

import com.alibaba.cloud.nacos.ConditionalOnNacosDiscoveryEnabled;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration;
import com.alibaba.cloud.nacos.registry.NacosRegistration;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import com.alibaba.cloud.nacos.registry.NacosServiceRegistry;
import com.bxm.component.preheat.registration.nacos.ManualNacosServiceRegistration;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnNacosDiscoveryEnabled
@ConditionalOnClass(value={NacosServiceRegistry.class, NacosRegistration.class})
@AutoConfigureAfter(value={NacosDiscoveryAutoConfiguration.class})
@EnableConfigurationProperties(value={AutoServiceRegistrationProperties.class})
public class PreheatNacosServiceRegistryAutoConfiguration {
    private AutoServiceRegistrationProperties properties;

    @Bean
    @ConditionalOnBean(value={NacosDiscoveryProperties.class})
    public NacosServiceRegistry nacosServiceRegistry(NacosDiscoveryProperties nacosDiscoveryProperties) {
        return new NacosServiceRegistry(nacosDiscoveryProperties);
    }

    @Bean
    @ConditionalOnBean(value={NacosDiscoveryProperties.class})
    public NacosRegistration nacosRegistration(ObjectProvider<List<NacosRegistrationCustomizer>> registrationCustomizers, NacosDiscoveryProperties nacosDiscoveryProperties, ApplicationContext context) {
        return new NacosRegistration((List)registrationCustomizers.getIfAvailable(), nacosDiscoveryProperties, context);
    }

    @Bean
    public ManualNacosServiceRegistration nacosAutoServiceRegistration(NacosServiceRegistry registry, NacosRegistration registration) {
        return new ManualNacosServiceRegistration((ServiceRegistry<Registration>)registry, this.properties, registration);
    }
}

