/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.quartz;

import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.vo.Message;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractCustomJob
extends QuartzJobBean {
    private Logger logger = LoggerFactory.getLogger(AbstractCustomJob.class);
    private String jobName;
    private String cron;
    private String group;
    private String description;
    private int priority;
    private Map<String, Object> param;

    public AbstractCustomJob(String jobName, String cron, String description) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = "default";
        this.description = description;
    }

    public AbstractCustomJob(String jobName, String group, String cron, String description) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = group;
        this.description = description;
    }

    public AbstractCustomJob(String jobName, String group, String cron, String description, int priority, Map<String, Object> param) {
        this.jobName = jobName;
        this.cron = cron;
        this.group = group;
        this.description = description;
        this.priority = priority;
        this.param = param;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCron() {
        return this.cron;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return this.priority;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    protected void executeInternal(JobExecutionContext context) {
        try {
            Message result = this.service();
            if (!result.isSuccess()) {
                this.saveLog(result);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.saveLog(Message.build().setMessage(e.getMessage()).setSuccess(false));
        }
    }

    protected abstract Message service();

    protected void saveLog(Message errorMsg) {
        this.logger.error(LogMarker.BIZ, "quartz error:[{}]", (Object)errorMsg);
    }
}

