package com.bxm.newidea.component.quartz.service;


import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;


/**
 * 定时任务接口包括定时任务初始化，更新，暂停，立即运行，删除
 * @author yuan 2018/6/6 14:03
 */
public interface ScheduleJobService {

    /**
     * 立即运行任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message runOnce(String jobName, String jobGroup);

    /**
     * 恢复任务
     * @return 响应消息
     */
    Message resumeScheduleJob(String jobName, String jobGroup);

    /**
     * 暂停任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message pauseScheduleJob(String jobName, String jobGroup);

    /**
     * 更新任务
     * @param scheduleJobBean 传入的任务参数
     * @param scheduleJobBean 任务参数
     * @return 响应消息
     */
    Message updateScheduleJob(ScheduleJobBean scheduleJobBean);

    /**
     * 删除任务
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 响应消息
     */
    Message deleteScheduleJob(String jobName, String jobGroup);

    /**
     * 获取定时任务分页列表
     * @param scheduleJobPageParam 分页参数
     * @return 响应消息
     */
    PageWarper<ScheduleJobBean> selectByPageNumSize(ScheduleJobPageParam scheduleJobPageParam);

    /**
     * 根据任务名称和任务分组获取定时任务信息
     * @param jobName  任务名称
     * @param jobGroup 任务分组
     * @return 定时任务信息
     */
    ScheduleJobBean selectByJobNameAndJobGroup(String jobName, String jobGroup);

}
