package com.bxm.newidea.component.redis.impl;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/8/23 6:40 下午
 */
@Slf4j
public class MultiDataKeyGenerator extends DefaultKeyGenerator {
    private MultiDataKeyGenerator(String dbName, String module, String group, String key) {
        super(module, group, key);
        this.dbName = dbName;
    }

    private MultiDataKeyGenerator(String dbName) {
        super();
        this.dbName = dbName;
    }

    protected MultiDataKeyGenerator(String dbName, String module, String group) {
        super(module, group);
        this.dbName = dbName;
    }

    public static MultiDataKeyGenerator buildWithDB(String dbName) {
        return new MultiDataKeyGenerator(dbName);
    }

    public static MultiDataKeyGenerator buildWithDB(String dbName, String module, String group) {
        return new MultiDataKeyGenerator(dbName, module, group);
    }

    public static MultiDataKeyGenerator buildWithDB(String dbName, String module, String group, String key) {
        return new MultiDataKeyGenerator(dbName, module, group, key);
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }
}