/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.utils;

import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.utils.RateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateLimiterFactory {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterFactory.class);
    private final DistributedLock distributedLock;
    private final RedisStringAdapter redisStringAdapter;
    private volatile Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();

    @Autowired
    public RateLimiterFactory(DistributedLock distributedLock, RedisStringAdapter redisStringAdapter) {
        this.distributedLock = distributedLock;
        this.redisStringAdapter = redisStringAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimiter build(KeyGenerator key, Double permitsPerSecond, Integer maxBurstSeconds) {
        String keyStr = key.gen();
        if (!this.rateLimiterMap.containsKey(keyStr)) {
            RateLimiterFactory rateLimiterFactory = this;
            synchronized (rateLimiterFactory) {
                if (!this.rateLimiterMap.containsKey(keyStr)) {
                    this.rateLimiterMap.put(keyStr, new RateLimiter(key, permitsPerSecond, maxBurstSeconds, this.distributedLock, this.redisStringAdapter));
                }
            }
        }
        return this.rateLimiterMap.get(keyStr);
    }
}

