/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RedisListAdapterImpl
extends BaseRedisAdapter
implements RedisListAdapter {
    private ListOperations operations;

    @Autowired
    public RedisListAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForList();
    }

    @Override
    public Long leftPush(KeyGenerator generator, Object ... values) {
        return this.execPush(generator, true, values);
    }

    @Override
    public <T> Long leftPush(KeyGenerator generator, List<T> value) {
        if (!CollectionUtils.isEmpty(value)) {
            return this.execPush(generator, true, value.toArray());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Long execPush(KeyGenerator generator, boolean isLeft, T[] values) {
        if (ArrayUtils.isEmpty((Object[])values)) {
            return 0L;
        }
        String key = generator.gen();
        try {
            List<byte[]> result = this.convertToByteArray(values);
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Long l = isLeft ? this.operations.leftPushAll((Object)key, result) : this.operations.rightPushAll((Object)key, result);
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    private <T> List<byte[]> convertToByteArray(T ... values) {
        ArrayList<byte[]> dataArray = new ArrayList<byte[]>();
        for (T obj : values) {
            dataArray.add(this.getSerializerWithoutType().serialize(obj));
        }
        return dataArray;
    }

    @Override
    public <T> Long rightPush(KeyGenerator generator, T ... values) {
        return this.execPush(generator, false, values);
    }

    @Override
    public Long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    @Override
    public <T> T leftPop(KeyGenerator generator, Class<T> clasz) {
        return this.execPop(generator, true, clasz, null);
    }

    @Override
    public <T> T leftPop(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.execPop(generator, true, null, typeReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execPop(KeyGenerator generator, boolean isLeft, Class<T> clasz, TypeReference<T> typeReference) {
        try {
            String key = generator.gen();
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Object value = isLeft ? this.operations.leftPop((Object)generator.gen()) : this.operations.rightPop((Object)generator.gen());
            T t = this.deserialize(value, clasz);
            return t;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    @Override
    public <T> T rightPop(KeyGenerator generator, Class<T> clasz) {
        return this.execPop(generator, false, clasz, null);
    }

    @Override
    public <T> T rightPop(KeyGenerator generator, TypeReference<T> typeReference) {
        return this.execPop(generator, false, null, typeReference);
    }

    @Override
    public <T> List<T> leftIndex(KeyGenerator generator, long index, Class<T> clasz) {
        return this.range(generator, 0L, index, clasz);
    }

    @Override
    public <T> List<T> leftIndex(KeyGenerator generator, long index, TypeReference<T> typeReference) {
        return this.range(generator, 0L, index, typeReference);
    }

    @Override
    public <T> T index(KeyGenerator generator, long index, Class<T> clasz) {
        Object value = this.operations.index((Object)generator.gen(), index);
        return this.deserialize(value, clasz);
    }

    @Override
    public <T> T index(KeyGenerator generator, long index, TypeReference<T> typeReference) {
        Object value = this.operations.index((Object)generator.gen(), index);
        return (T)this.getSerializer(typeReference).deserialize((byte[])value);
    }

    @Override
    public <T> List<T> range(KeyGenerator generator, long start, long end, Class<T> clasz) {
        ArrayList result = new ArrayList();
        List values = this.operations.range((Object)generator.gen(), start, end);
        if (!CollectionUtils.isEmpty((Collection)values)) {
            RedisSerializer serializer = this.getSerializer(clasz);
            values.forEach(value -> result.add(serializer.deserialize((byte[])value)));
        }
        return result;
    }

    @Override
    public <T> List<T> range(KeyGenerator generator, long start, long end, TypeReference<T> typeReference) {
        ArrayList result = new ArrayList();
        List values = this.operations.range((Object)generator.gen(), start, end);
        if (!CollectionUtils.isEmpty((Collection)values)) {
            RedisSerializer serializer = this.getSerializer(typeReference);
            values.forEach(value -> result.add(serializer.deserialize((byte[])value)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftTrim(KeyGenerator generator, long start, long end) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            this.operations.trim((Object)generator.gen(), start, end);
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }
}

