package com.bxm.newidea.component.redis;

/**
 * 估算基数相关方法:
 * 基数计算（cardinality counting）指的是统计一批数据中的不重复元素的个数，
 * 常见于计算独立用户数（UV）、维度的独立取值数等等。实现基数统计最直接的方法，
 * 就是采用集合（Set）这种数据结构，当一个元素从未出现过时，
 * 便在集合中增加一个元素；如果出现过，那么集合仍保持不变。
 */
public interface HyperLogLogAdapter extends BaseRedisOperation {

    /**
     * 用途：将批量值插入当前键值
     *
     * @param keyGenerator
     * @param value
     * @param <T>
     * @return
     */
    <T> Long add(KeyGenerator keyGenerator, T... value);

    /**
     * 用途：计算多个键值相加的基数总数
     *
     * @param keyGenerators
     * @return
     */
    Long size(KeyGenerator... keyGenerators);


    /**
     * 用途：将多个@keyGenerators合并到@keyGenerator中，
     * 也就是将多个HyperLogLog合并（merge）为一个HyperLogLog，
     * 合并后的HyperLogLog的基数接近于所有输入HyperLogLog的可见集合(observed set)的并集。
     *
     * @param keyGenerator
     * @param keyGenerators
     * @return
     */
    Long union(KeyGenerator keyGenerator, KeyGenerator... keyGenerators);

}
