package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Component
public class HyperLogLogAdapterImpl extends BaseRedisAdapter implements HyperLogLogAdapter {

    private HyperLogLogOperations<String, Object> hyperLogLogOperations;

    @Autowired
    public HyperLogLogAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.hyperLogLogOperations = redisTemplate.opsForHyperLogLog();
    }

    @SafeVarargs
    @Override
    public final <T> Long add(KeyGenerator keyGenerator, T... value) {
        String key = keyGenerator.gen();
        try {
            redisTemplate.watch(key);
            redisTemplate.multi();

            return hyperLogLogOperations.add(key, serializeWithoutType(value));
        } finally {
            redisTemplate.unwatch();
        }
    }

    @Override
    public Long size(KeyGenerator... keyGenerators) {
        String[] keyGeneratorArray = Arrays.stream(keyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        return hyperLogLogOperations.size(keyGeneratorArray);
    }


    @Override
    public Long union(KeyGenerator keyGenerator, KeyGenerator... sourceKeyGenerators) {
        String[] keyGeneratorArray = Arrays.stream(sourceKeyGenerators).map(KeyGenerator::gen).toArray(String[]::new);
        return hyperLogLogOperations.union(keyGenerator.gen(),keyGeneratorArray);
    }
}
