/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.redis.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.impl.BaseRedisAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class RedisSetAdapterImpl
extends BaseRedisAdapter
implements RedisSetAdapter {
    private SetOperations operations;

    @Autowired
    public RedisSetAdapterImpl(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.operations = redisTemplate.opsForSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long add(KeyGenerator generator, Object ... values) {
        String key = generator.gen();
        try {
            this.redisTemplate.watch((Object)key);
            this.redisTemplate.multi();
            Long l = this.operations.add((Object)key, (Object[])this.serializeWithoutType(values));
            return l;
        }
        finally {
            this.redisTemplate.unwatch();
        }
    }

    public <T> Long remove(KeyGenerator generator, Object ... values) {
        return this.operations.remove((Object)generator.gen(), (Object[])this.serialize(values));
    }

    public <T> Boolean exists(KeyGenerator generator, T value) {
        return this.operations.isMember((Object)generator.gen(), (Object)Objects.requireNonNull(this.getSerializerWithoutType().serialize(value)));
    }

    public <T> List<T> pop(KeyGenerator generator, Long count, Class<T> clasz) {
        RedisSerializer serializer = this.getSerializer(clasz);
        return this.innerPop(generator, count, serializer);
    }

    public <T> List<T> pop(KeyGenerator generator, Long count, TypeReference<T> typeReference) {
        RedisSerializer serializer = this.getSerializer(typeReference);
        return this.innerPop(generator, count, serializer);
    }

    private <T> List<T> innerPop(KeyGenerator generator, Long count, RedisSerializer<T> redisSerializer) {
        List result = this.operations.pop((Object)generator.gen(), count.longValue());
        List<Object> finalResult = Lists.newArrayList();
        if (result != null) {
            finalResult = result.stream().map(arg_0 -> redisSerializer.deserialize(arg_0)).collect(Collectors.toList());
        }
        return finalResult;
    }

    public Long size(KeyGenerator generator) {
        return this.operations.size((Object)generator.gen());
    }

    public <T> Set<T> getAllMembers(KeyGenerator generator, Class<T> clasz) {
        RedisSerializer serializer = this.getSerializer(clasz);
        return this.innerGetAllMemers(generator, serializer);
    }

    public <T> Set<T> getAllMembers(KeyGenerator generator, TypeReference<T> typeReference) {
        RedisSerializer serializer = this.getSerializer(typeReference);
        return this.innerGetAllMemers(generator, serializer);
    }

    private <T> Set<T> innerGetAllMemers(KeyGenerator generator, RedisSerializer<T> redisSerializer) {
        Cursor cursor = this.operations.scan((Object)generator.gen(), ScanOptions.scanOptions().count(10000L).build());
        HashSet<Object> result = new HashSet<Object>();
        while (cursor.hasNext()) {
            result.add(redisSerializer.deserialize((byte[])cursor.next()));
        }
        return result;
    }

    private <T> Set<T> deserialize(Set<Object> data, Class<T> clasz) {
        HashSet result = new HashSet();
        if (null != data && data.size() > 0) {
            data.forEach(item -> result.add(this.getSerializer(clasz).deserialize((byte[])item)));
        }
        return result;
    }

    public <T> Set<T> difference(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.difference((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    public Long differenceAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.differenceAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    public <T> Set<T> inter(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.intersect((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    public Long interAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.intersectAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    public <T> Set<T> union(KeyGenerator generator, Class<T> clasz, KeyGenerator ... otherGenerators) {
        return this.deserialize(this.operations.union((Object)generator.gen(), this.convertKeys(otherGenerators)), clasz);
    }

    public Long unionAndStore(KeyGenerator storeGenerator, KeyGenerator generator, KeyGenerator ... otherGenerators) {
        if (storeGenerator == null) {
            return 0L;
        }
        return this.operations.unionAndStore((Object)generator.gen(), this.convertKeys(otherGenerators), (Object)storeGenerator.gen());
    }

    public <T> Boolean move(KeyGenerator sourceKey, KeyGenerator targetKey, T item, Class<T> clasz) {
        return this.operations.move((Object)sourceKey.gen(), (Object)Objects.requireNonNull(this.getSerializer(clasz).serialize(item)), (Object)targetKey.gen());
    }
}

