package com.bxm.newidea.component.schedule.facade;

import com.bxm.newidea.component.schedule.facade.fallback.ScheduleFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "service-schedule", fallbackFactory = ScheduleFallbackFactory.class)
public interface ScheduleFeignService {

    @PostMapping("facade/jobInfo/add")
    void add(@RequestParam("jobName") String jobName,
             @RequestParam("jobCron") String jobCron,
             @RequestParam("jobDesc") String jobDesc,
             @RequestParam("executorName") String executorName,
             @RequestParam("executorHandler") String executorHandler,
             @RequestParam("executorParam") String executorParam,
             @RequestParam("executorRouteStrategy") String executorRouteStrategy,
             @RequestParam("executorBlockStrategy") String executorBlockStrategy,
             @RequestParam("author") String author);

    @PostMapping("facade/jobInfo/update")
    void update(@RequestParam("jobName") String jobName,
                @RequestParam("jobCron") String jobCron,
                @RequestParam("jobDesc") String jobDesc,
                @RequestParam("executorName") String executorName,
                @RequestParam("executorHandler") String executorHandler,
                @RequestParam("executorParam") String executorParam,
                @RequestParam("executorRouteStrategy") String executorRouteStrategy,
                @RequestParam("executorBlockStrategy") String executorBlockStrategy,
                @RequestParam("author") String author);

    @PostMapping("facade/jobInfo/remove")
    void remove(@RequestParam("jobName") String jobName);
}

