package com.bxm.newidea.component.schedule.integration;

import com.bxm.newidea.component.schedule.constant.ExecutorRouteStrategyEnum;
import com.bxm.newidea.component.schedule.facade.ScheduleFeignService;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class ScheduleIntegrationService {

    @Resource
    private ScheduleFeignService scheduleFeignService;

    /**
     * 简单添加任务，功能参数较少
     *
     * @param jobName         任务名称，须具有唯一性
     * @param jobCron         cron表达式
     * @param jobDesc         任务描述
     * @param executorName    执行器名称，即app名称
     * @param executorHandler 执行器具体任务handler名称
     * @param executorParam   执行器所需参数
     */
    public void simpleAdd(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam) {
        scheduleFeignService.add(jobName, jobCron, jobDesc, executorName, executorHandler, executorParam,
                ExecutorRouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), executorName);
    }

    /**
     * 复杂添加任务，功能参数较多
     *
     * @param jobName               任务名称，须具有唯一性
     * @param jobCron               cron表达式
     * @param jobDesc               任务描述
     * @param executorName          执行器名称，即app名称
     * @param executorHandler       执行器具体任务handler名称
     * @param executorParam         执行器所需参数
     * @param executorRouteStrategy 路由策略
     * @param executorBlockStrategy 阻塞策略
     * @param author                负责人
     */
    public void complexAdd(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam,
                           String executorRouteStrategy, String executorBlockStrategy, String author) {
        scheduleFeignService.add(jobName, jobCron, jobDesc, executorName, executorHandler, executorParam,
                executorRouteStrategy, executorBlockStrategy, author);
    }

    /**
     * 简单更新任务，功能参数较少
     *
     * @param jobName         任务名称，须具有唯一性
     * @param jobCron         cron表达式
     * @param jobDesc         任务描述
     * @param executorName    执行器名称，即app名称
     * @param executorHandler 执行器具体任务handler名称
     * @param executorParam   执行器所需参数
     */
    public void simpleUpdate(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam) {
        scheduleFeignService.update(jobName, jobCron, jobDesc, executorName, executorHandler, executorParam,
                ExecutorRouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), executorName);
    }

    /**
     * 复杂更新任务，功能参数较多
     *
     * @param jobName               任务名称，须具有唯一性
     * @param jobCron               cron表达式
     * @param jobDesc               任务描述
     * @param executorName          执行器名称，即app名称
     * @param executorHandler       执行器具体任务handler名称
     * @param executorParam         执行器所需参数
     * @param executorRouteStrategy 路由策略
     * @param executorBlockStrategy 阻塞策略
     * @param author                负责人
     */
    public void complexUpdate(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam,
                              String executorRouteStrategy, String executorBlockStrategy, String author) {
        scheduleFeignService.update(jobName, jobCron, jobDesc, executorName, executorHandler, executorParam,
                executorRouteStrategy, executorBlockStrategy, author);
    }

    /**
     * 移除任务
     *
     * @param jobName 任务名称
     */
    public void remove(String jobName) {
        scheduleFeignService.remove(jobName);
    }

}

