/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.api.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.api.ScheduleService;
import com.bxm.newidea.component.schedule.config.XxlJobConfig;
import com.bxm.newidea.component.schedule.constant.RouteStrategyEnum;
import com.bxm.newidea.component.schedule.facade.ScheduleFeignService;
import com.bxm.newidea.component.schedule.param.ComplexJob;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.param.SimpleJob;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    @Resource
    private XxlJobConfig xxlJobConfig;
    @Resource
    private ScheduleFeignService scheduleFeignService;

    @Override
    public void simpleAdd(SimpleJob simpleJob) {
        if (this.isNotValid(simpleJob)) {
            return;
        }
        this.scheduleFeignService.add(simpleJob.getJobName(), simpleJob.getJobCron(), simpleJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(simpleJob.getTaskName(), simpleJob.getParams())), RouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), this.xxlJobConfig.getAppName());
    }

    @Override
    public void complexAdd(ComplexJob complexJob) {
        if (this.isNotValid(complexJob)) {
            return;
        }
        this.scheduleFeignService.add(complexJob.getJobName(), complexJob.getJobCron(), complexJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(complexJob.getTaskName(), complexJob.getParams())), complexJob.getRouteStrategy().name(), complexJob.getBlockStrategy().name(), complexJob.getAuthor());
    }

    @Override
    public void simpleUpdate(SimpleJob simpleJob) {
        if (this.isNotValid(simpleJob)) {
            return;
        }
        this.scheduleFeignService.update(simpleJob.getJobName(), simpleJob.getJobCron(), simpleJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(simpleJob.getTaskName(), simpleJob.getParams())), RouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), this.xxlJobConfig.getAppName());
    }

    @Override
    public void complexUpdate(ComplexJob complexJob) {
        if (this.isNotValid(complexJob)) {
            return;
        }
        this.scheduleFeignService.update(complexJob.getJobName(), complexJob.getJobCron(), complexJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(complexJob.getTaskName(), complexJob.getParams())), complexJob.getRouteStrategy().name(), complexJob.getBlockStrategy().name(), complexJob.getAuthor());
    }

    @Override
    public void remove(String jobName) {
        if (StringUtils.isBlank((String)jobName)) {
            return;
        }
        this.scheduleFeignService.remove(jobName);
    }

    private boolean isNotValid(SimpleJob simpleJob) {
        if (null == simpleJob) {
            return true;
        }
        return StringUtils.isBlank((String)simpleJob.getJobName()) || StringUtils.isBlank((String)simpleJob.getJobCron()) || StringUtils.isBlank((String)simpleJob.getJobDesc()) || StringUtils.isBlank((String)simpleJob.getTaskName());
    }

    private boolean isNotValid(ComplexJob complexJob) {
        if (null == complexJob) {
            return true;
        }
        return StringUtils.isBlank((String)complexJob.getJobName()) || StringUtils.isBlank((String)complexJob.getJobCron()) || StringUtils.isBlank((String)complexJob.getJobDesc()) || StringUtils.isBlank((String)complexJob.getTaskName()) || StringUtils.isBlank((String)complexJob.getAuthor()) || null == complexJob.getRouteStrategy() || null == complexJob.getBlockStrategy();
    }
}

