/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.rpc;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.config.ExecutorParam;
import com.bxm.newidea.component.schedule.config.XxlJobConfiguration;
import com.bxm.newidea.component.schedule.rpc.ScheduleFeignService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class ScheduleServiceImpl
implements ScheduleService,
ApplicationContextAware,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private XxlJobConfiguration xxlJobConfiguration;
    private ScheduleFeignService scheduleFeignService;
    private ApplicationContext applicationContext;

    public ScheduleServiceImpl(XxlJobConfiguration xxlJobConfiguration, ScheduleFeignService scheduleFeignService) {
        this.xxlJobConfiguration = xxlJobConfiguration;
        this.scheduleFeignService = scheduleFeignService;
    }

    @Override
    public boolean push(ScheduleTask task) {
        if (this.validate(task)) {
            if (task.onceTask()) {
                this.scheduleFeignService.update(task.taskName(), task.cron(), task.description(), this.xxlJobConfiguration.getAppName(), "beanByNameHandler", this.buildParam(task), task.routeStrategy().name(), task.blockStrategy().name(), task.author());
            } else {
                this.scheduleFeignService.add(task.taskName(), task.cron(), task.description(), this.xxlJobConfiguration.getAppName(), "beanByNameHandler", this.buildParam(task), task.routeStrategy().name(), task.blockStrategy().name(), task.author());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String taskName) {
        if (StringUtils.isNotBlank((String)taskName)) {
            this.scheduleFeignService.remove(taskName);
            return true;
        }
        return false;
    }

    private String buildParam(ScheduleTask task) {
        return JSON.toJSONString((Object)new ExecutorParam(task.callback().beanName(), task.callbackParam()));
    }

    private boolean validate(ScheduleTask task) {
        if (StringUtils.isBlank((String)task.taskName())) {
            log.error("\u4efb\u52a1\u540d\u672a\u914d\u7f6e");
            return false;
        }
        if (null == task.cron()) {
            log.error("\u4efb\u52a1\u672a\u8bbe\u7f6e\u6267\u884c\u65f6\u95f4");
            return false;
        }
        if (null == task.callback()) {
            log.error("\u4efb\u52a1\u56de\u8c03\u670d\u52a1\u7c7b\u672a\u8bbe\u7f6e");
            return false;
        }
        if (!this.applicationContext.containsBean(task.callback().beanName())) {
            log.error("\u4efb\u52a1\u56de\u8c03\u670d\u52a1\u7c7b\u672a\u8bbe\u7f6e\u5230Spring\u4e0a\u4e0b\u6587");
            return false;
        }
        return true;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map taskMap = this.applicationContext.getBeansOfType(ScheduleTask.class);
        if (taskMap.size() > 0) {
            taskMap.values().forEach(this::push);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

