package com.bxm.component.dubbo.spring;

import com.alibaba.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationAttributes;

import java.util.Map;

import static com.alibaba.spring.util.AnnotationUtils.getAttributes;
import static org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder.create;

/**
 * @author liujia
 * @date 7/22/21 3:09 PM
 **/
@Slf4j
public class MockDubboReferenceBeanProcessor extends AbstractAnnotationBeanPostProcessor implements
        ApplicationContextAware, ApplicationListener {

    public MockDubboReferenceBeanProcessor() {
        super(DubboReference.class, Reference.class, com.alibaba.dubbo.config.annotation.Reference.class);
    }

    @Override
    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType,
                                       InjectionMetadata.InjectedElement injectedElement) throws Exception {
        // 判断是否已经提供的相同的实例，用本地mock代替远程实现
        Map<String, Object> exitsBeanMap = (Map<String, Object>) applicationContext.getBeansOfType(injectedType);
        if (exitsBeanMap.size() > 0) {
            return getBeanFactory().applyBeanPostProcessorsAfterInitialization(exitsBeanMap.values().iterator().next(), beanName);
        }

        // 非测试、本地调试，则提供一个空的实现，仅仅为了不报错
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(injectedType);
        enhancer.setCallback(new EmptyMethodInterceptor());

        Object proxyBean = enhancer.create();

        return getBeanFactory().applyBeanPostProcessorsAfterInitialization(proxyBean, beanName);
    }


    @Override
    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return buildReferencedBeanName(attributes, injectedType) +
                "#source=" + (injectedElement.getMember()) +
                "#attributes=" + getAttributes(attributes, getEnvironment());
    }

    private String buildReferencedBeanName(AnnotationAttributes attributes, Class<?> serviceInterfaceType) {
        ServiceBeanNameBuilder serviceBeanNameBuilder = create(attributes, serviceInterfaceType, getEnvironment());
        return serviceBeanNameBuilder.build();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
    }

    private ApplicationContext applicationContext;

    public static final String BEAN_NAME = "mockDubboReferenceBeanProcessor";
}
