package com.bxm.component.dubbo.config;

import com.bxm.component.dubbo.spring.DubboServiceScanRegistrar;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

/**
 * 扫描@DubboService和@DubboReference
 * 将DubboService注册为普通的spring bean方便进行本地调试
 * DubboReference如果存在对应的spring bean实现类，则进行注入（测试用例模拟的情况）
 * DubboReference如果不存在spring bean，则创建一个模拟实现
 *
 * @author liujia
 * @date 7/22/21 2:28 PM
 **/
@Configuration
@Profile({
    "LOCAL",
    "local",
    "TEST",
    "test"
})
@Import(DubboServiceScanRegistrar.class)
@EnableAutoConfiguration(exclude = {
    com.alibaba.cloud.dubbo.autoconfigure.DubboMetadataAutoConfiguration.class,
    com.alibaba.cloud.dubbo.autoconfigure.DubboLoadBalancedRestTemplateAutoConfiguration.class,
    com.alibaba.cloud.dubbo.autoconfigure.DubboOpenFeignAutoConfiguration.class,
    com.alibaba.cloud.dubbo.autoconfigure.DubboServiceDiscoveryAutoConfiguration.class,
    com.alibaba.cloud.dubbo.autoconfigure.DubboServiceRegistrationAutoConfiguration.class,
    com.alibaba.cloud.dubbo.actuate.DubboMetadataEndpointAutoConfiguration.class,
    org.apache.dubbo.spring.boot.autoconfigure.DubboAutoConfiguration.class,
    com.alibaba.cloud.dubbo.autoconfigure.DubboServiceRegistrationNonWebApplicationAutoConfiguration.class
})
public class DubboTestSupportConfiguration {
}
