/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.dubbo.spring;

import com.alibaba.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import com.alibaba.spring.util.AnnotationUtils;
import com.bxm.component.dubbo.spring.EmptyMethodInterceptor;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class MockDubboReferenceBeanProcessor
extends AbstractAnnotationBeanPostProcessor
implements ApplicationContextAware,
ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(MockDubboReferenceBeanProcessor.class);
    private ApplicationContext applicationContext;
    public static final String BEAN_NAME = "mockDubboReferenceBeanProcessor";

    public MockDubboReferenceBeanProcessor() {
        super(new Class[]{DubboReference.class, Reference.class, com.alibaba.dubbo.config.annotation.Reference.class});
    }

    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        Map exitsBeanMap = this.applicationContext.getBeansOfType(injectedType);
        if (exitsBeanMap.size() > 0) {
            return this.getBeanFactory().applyBeanPostProcessorsAfterInitialization(exitsBeanMap.values().iterator().next(), beanName);
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(injectedType);
        enhancer.setCallback((Callback)new EmptyMethodInterceptor());
        Object proxyBean = enhancer.create();
        return this.getBeanFactory().applyBeanPostProcessorsAfterInitialization(proxyBean, beanName);
    }

    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return this.buildReferencedBeanName(attributes, injectedType) + "#source=" + injectedElement.getMember() + "#attributes=" + AnnotationUtils.getAttributes((Map)attributes, (PropertyResolver)this.getEnvironment(), (String[])new String[0]);
    }

    private String buildReferencedBeanName(AnnotationAttributes attributes, Class<?> serviceInterfaceType) {
        ServiceBeanNameBuilder serviceBeanNameBuilder = ServiceBeanNameBuilder.create((AnnotationAttributes)attributes, serviceInterfaceType, (Environment)this.getEnvironment());
        return serviceBeanNameBuilder.build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
    }
}

