/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.filter;

import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.exception.ExcutorException;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class FilterChainExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(FilterChainExecutor.class);
    private Map<String, List<IFilter>> groupFilterMap = new HashMap<String, List<IFilter>>();

    public <T> void doFilter(String group, T context) {
        List<IFilter> filters = this.groupFilterMap.get(group);
        if (null == filters) {
            return;
        }
        for (IFilter filter : filters) {
            try {
                filter.doFilter(context);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ExcutorException("\u8fc7\u6ee4\u5668\u6267\u884c\u5931\u8d25\uff1a" + filter.getClass().getSimpleName(), e);
            }
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        for (IFilter iFilter : SpringContextHolder.getBeans(IFilter.class)) {
            FilterBean annotation = (FilterBean)AnnotationUtils.findAnnotation(iFilter.getClass(), FilterBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bFilterBean\u6ce8\u89e3", (Object)iFilter.getClass().getSimpleName());
                continue;
            }
            List<IFilter> filters = this.groupFilterMap.get(annotation.group());
            if (filters == null) {
                filters = new ArrayList<IFilter>();
            }
            filters.add(iFilter);
            this.groupFilterMap.put(annotation.group(), filters);
        }
        for (List list : this.groupFilterMap.values()) {
            OrderComparator.sort((List)list);
        }
    }
}

