package com.bxm.newidea.component.listener;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * 额外增加应用启动的监听，记录启动过程，并且在启动失败时阻塞，便于查找问题
 *
 * @author liujia
 * @date 6/7/21 4:20 PM
 **/
@Slf4j
public class PrintApplicationRunListener implements SpringApplicationRunListener {

    public PrintApplicationRunListener(SpringApplication application, String[] args) {
    }

    @Override
    public void starting() {
        log.info("应用启动中");
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        log.info("上下文环境已准备完成");
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
        log.info("applicationContext创建完成");
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
        log.info("applicationContext加载完成");
    }

    @Override
    public void started(ConfigurableApplicationContext context) {
        log.info("应用启动完成");
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
        log.info("应用运行中");
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        if (exception != null) {
            log.error("应用启动失败，" + exception.getMessage(), exception);
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                log.error("application started failed", e);
            }
        }
    }
}
