package com.bxm.component.tbk.order.model.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 因为回调是get请求，无法做下划线和驼峰的转换
 * 所以这里定义一个类用来接收
 */
@Data
public class MeituanOrderSourceInfo {

    /**
     * 推送ID
     */
    private String id;

    /**
     * 推广计划ID
     */
    private String ads_id;

    /**
     * 	推广计划名称
     */
    private String ads_name;

    /**
     * 媒体ID
     */
    private String site_id;


    /**
     * 推广计划链接ID
     */
    private String link_id;

    /**
     * 订单的反馈标签值
     */
    private String euid;

    /**
     * 订单编号
     */
    private String order_sn;

    /**
     * 订单下单时间
     */
    private String order_time;

    /**
     * 订单金额，当订单状态为 1 或者为 2 时， order_price 表示确认订单金额
     */
    private BigDecimal orders_price;

    /**
     * 订单佣金，当订单状态为 1 或者为 2 时，siter_commission 表示确认佣金，其他状态值为 订单预估佣金
     */
    private BigDecimal siter_commission;

    /**
     * 推送数据校验参数,checksum=MD5（按照参数首字母升序排列后 “参数值”拼接string + 接口密钥hash），拼接的参数值中不包括checksum和id参数值
     */
    private String checksum;

    /**
     * 订单状态 -1 无效 0 未确认 1 确认 2 结算
     */
    private Integer status;

    // -----------------以下字段在订单查询接口中才有，订单推送是不返回的---------------------------------------

    /**
     * 	0.00	确认订单金额
     */
    private BigDecimal confirm_price;

    /**
     * 	0.00	确认订单佣金
     */
    private BigDecimal confirm_siter_commission;

    /**
     * 	0000-00-00 00:00:00	结算时间
     */
    private String charge_time;
}
