package com.bxm.component.tbk.order.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 订单定时任务相关配置
 * @author Gonzo
 * @date  2020-05-02 14:40
 * @since 2.0.0
 */
@Data
@Component
@ConfigurationProperties("order.config.timer")
public class OrderTimerConfigProperties {

    /**
     * 每日定时更新订单状态定时任务
     * 默认每天凌晨12:10分开始
     */
    private String updateOrderStatusCron = "0 10 0 * * ?";

    /**
     * 每隔一段时间拉拉取淘宝订单定时任务
     * 每2分钟执行一次,从第三方接口拉取订单信息
     */
    private String pullOrderCron = "0 0/2 * * * ? ";


    /**
     * 维权订单查询定时任务
     * 默认每天早上10:30分开始
     */
    private String orderRefundCron = "0 30 10 * * ?";

    /**
     * 饿了么订单状态同步和佣金结算定时任务
     * 默认每天11点启动
     */
    private String eleOrderStatusSyncAndCommissionSettleDaysCron = "0 0 11 * * ?";

    /**
     * 从第三方接口拉取订单信息
     * 每半天执行一次
     */
    private String pullOrderByDayCron = "0 0 0,12 * * ?";

    /**
     * 购物订单返佣结算
     * 每月24 25 26 号的凌晨3点开始执行
     */
    private String orderCommissionSettleCron = "0 0 3 24,25,26 * ?";

    /**
     * 多麦的美团订单佣金结算
     * 每月24 25 26 4点运行
     */
    private String duomaiMeituanOrderCommissionSettleMonthCron = "0 0 4 24,25,26 * ? ";

    /**
     * 美团订单每日同步定时任务
     * 每天凌晨0.20启动
     */
    private String duomaiMeituanOrderSyncDaysCron = "0 20 0 * * ?";

    /**
     * 订单每2分钟拉取一次的开关 true-拉取,false-关闭拉取
     */
    private Boolean pullOrderSwitch = Boolean.TRUE;

    /**
     * 订单每半天拉取一次的开关 true-拉取,false-关闭拉取
     */
    private Boolean pullOrderDaySwitch = Boolean.TRUE;

    /**
     * 常规订单拉取开关  true-拉取   false-关闭
     */
    private Boolean pullOrderSwitchGeneral = Boolean.TRUE;

    /**
     * 同步订单状态开关
     */
    private Boolean orderStatusSyncQuartzFlag = Boolean.TRUE;


    private Boolean activateCallbackFlag = Boolean.TRUE;

    /**
     * 常规订单拉取开关  true-拉取   false-关闭
     */
    private Boolean pullOrderSwitchMember = Boolean.TRUE;
}
