package com.bxm.component.tbk.order.config;

import com.bxm.newidea.component.enums.AppNameEnum;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 淘宝开发平台订单相关的配置信息
 * @Author: Gonzo
 * @date  2020-04-22 17:09
 * @since 1.7.0
 */
@Component
@ConfigurationProperties("order.config.tb-open.order")
@Data
public class TbkOpenOrderProperties {

    /**
     * 查询数据时的页面大小
     * 默认10
     */
    private Long queryPageSize = 10L;

    /**
     * 当前业务主体
     * 默认趣淘金
     */
    private String site = Objects.toString(AppNameEnum.FOSSICKER);

    /**
     * 推广位id
     * 默认趣淘金id 597650089
     * 万事通为 598100110
     */
    private String businessSiteId = "597650089";
}
