package com.bxm.component.tbk.order.model.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
public class TbkOrderPageInfo<T> {


    private List<T> list;

    /**
     * 是否还有下一页
     */
    private Boolean hasNext;

    /**
     * 是否还有上一页
     */
    private Boolean hasPre;

    /**
     * 页码
     */
    private Long pageNo;

    /**
     * 页大小
     */
    private Long pageSize;

    /**
     * 位点，除第一页之外，都需要传递；前端原样返回。
     */
    private String positionIndex;

    /**
     * 下一页页码
     * @return 下一页页码
     */
    public Long nextPageNo() {
        return this.pageNo + 1L;
    }

}
