package com.bxm.component.tbk.order.model.enums;

/**
 * 淘宝客订单状态
 * @author Gonzo
 * @date  2020-05-02 14:13
 * @since 2.0.0
 */
public enum TbkOrderStatusEnum {

    /**
     * 订单结算
     */
    HAVA_SETTLED(3, "订单结算"),
    HAVA_PAID(12, "订单付款"),
    INVALID(13, "订单失效"),
    SUC(14, "订单成功");


    TbkOrderStatusEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    /**
     * 淘宝订单状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String description;

    public Integer getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }
}
