package com.bxm.component.tbk.order.model.enums;

import java.util.Objects;

/**
 * 订单所属平台类型
 * @author Gonzo
 * @date  2020-05-02 14:10
 * @since 2.0.0
 */
public enum TbkOrderType {
    /**
     * 天猫
     */
    TMALL("天猫"),

    /**
     * 淘宝
     */
    TAOBAO("淘宝"),

    /**
     * 聚划算
     */
    JUHUASUAN("聚划算"),

    /**
     * 饿了么
     */
    ELE("饿了么"),
    ;

    private String type;

    TbkOrderType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    /**
     * 根据type 获取枚举名称
     * eg: type: 饿了么 return ELE
     * @param type type
     * @return 枚举名称
     */
    public static String getTypeEnum(String type) {
        TbkOrderType[] values = TbkOrderType.values();
        for (TbkOrderType value : values) {
            if (Objects.equals(value.type, type)) {
                return value.name();
            }
        }

        return "";
    }
}
